# Benefits and Application of Nanotechnology in Environmental Science: an Overview

Mojtaba Taran $\mathbf { 1 } \oplus$ , Mohsen Safaei $2 , \ast \textcircled { \mathbb { D } }$ , Naser Karimi $\mathbf { 1 } \oplus$ , Ali Almasi 3

1 Department of Nanobiotechnology, Faculty of Science, Razi University, Kermanshah, Iran   
2 Advanced Dental Sciences Research Laboratory, School of Dentistry, Kermanshah University of Medical Sciences, Kermanshah, Iran   
3 Department of Environmental Health Engineering, School of Public Health, Social Development and Health Promotion Research Center, Kermanshah University of Medical Sciences, Kermanshah, Iran   
\* Correspondence: mohsen_safaei@yahoo.com; safaei@kums.ac.ir;

Scopus Author ID 36612136800

Received: 14.05.2020; Revised: 28.06.2020; Accepted: 1.07.2020; Published: 5.07.2020

Abstract: As a result of world population growth, consumption of energy and materials is increasing, leading to environmental consequences. Some of these consequences include increased production of solid waste, increased air pollution caused by vehicles and industrial plants, contamination of surface and groundwater. Nanotechnology has the potential of improving the environment through direct application of nanomaterials for detecting, preventing, and removing pollutants and indirect application of them by using better industrial design process and production of products compatible with the environment. Nanoparticles show higher reactivity due to their small size and high surface. While this characteristic has various benefits and applications, it may have risks for the safety of employees and the environment, such as stay suspended in the air for a long time, possibility of accumulation in the environment, easy absorption, and damage to various organs of the body. This review has investigated the applications of nanotechnology in waste management, controlling and reducing air pollution, water treatment, and nanomaterials safety.

Keywords: Nanotechnology; Environmental Science; Air Pollution; Water Treatment; Waste Management; Nanomaterials Safety.

# 1. Introduction

Nanotechnology has been considered as an applied technology in various areas in recent decades. Nanotechnology has been developed by a convergence of various sciences, providing the way to work at the atomic level and to create new structures. Nanotechnology includes the production of nanosized materials and devices and controlling them in order to use their unique characteristics. By using this definition, it is found that nanotechnology has numerous applications in various areas of life sciences, engineering, and medicine [1-3]. One of the areas where nanotechnology can be used is the environment (Fig. 1). The best strategies for the health of environment like human health involves three forms of prevention, care, and treatment [4, 5] so that before a big risk we should take care of the environment carefully and take deliberate measures to deal with it. Nanosensors will allow us to detect and to follow the effects of human activities on the environment accurately and quickly. Finally, when a risk occurred more than its usual level, nanotechnology solutions can be used to reduce environmental damage.

Nanotechnology helps us in refining existing pollutions and proper use of our available resources [5, 6].

Applying nanotechnology will increase the efficiency of clean energy production. For example, solar cells, wind, sea, and geothermal energy can produce much energy efficiently using nanomaterials, and fossil energy will be replaced by renewable energy. Nanotechnology has caused the material to be consumed in a way that it effectively reduces the entering of pollutants, resulting from human activities, to the environment. In the wake of changes in industries using nanotechnology, we can produce the materials that are digestible in the environment and can be converted into another commodity. A planned movement toward some industries will reduce environmental damage. This is possible by nanotechnology [6, 7].

Due to changes in lifestyle and increasing use of technology, the current world industry is faced with various environmental problems. This study deals with a potential application of nanotechnology to solve major environmental problems such as municipal solid waste management, air pollution, water scarcity, and nanomaterials safety.

![](images/671ccd7a8fde2e84502f6995e63e33f5fdc1e1a7e8d5c62c2c9b4fafe5e68b17.jpg)  
Figure 1. Important usage of nanotechnology in environmental science.

# 2. Nanotechnology and Waste Management

Solid waste materials refer to materials produced by human activities to satisfy his needs and entered the environment. Cause of the increasing population, and changes in people's lifestyles, the production of these materials is one of the environmental threats at the current time. Various types of dangerous organic and inorganic pollutants are entered into the water, soil, and air by industrial and urban waste. It is impossible to remove these pollutants simply by existing technologies. Therefore, employing modern technologies such as nanotechnology could have an important role in solving this problem. Some of the nanomaterials used widely in waste management include nanofilters, nanosensors, nanophotocatalysts, and nanoparticles [8, 9].

# 2.1. Nanofilters in waste management.

Toxic and nonbiodegradable materials (arsenic, xenobiotic organic compounds, ammonia, inorganic macro components, heavy metals, etc.) in wastes and their leachate have caused that common biological and physicochemical methods cannot eliminate them at environmental standards. Therefore, the use of pretreatment, posttreatment, and modern technologies is considered in removing contaminants from the environment. Nanofiltration has been considered in waste treatment without any need for chemicals that produced waste is concentrated and intensive, reducing its transportation and disposal cost. Applying nanofilters can remove 60 to $7 0 \%$ of COD and $5 0 \%$ of ammonium in the leachate. Nanofilters can be used to remove a wide range of pollutants such as anions and cations, arsenic, uranium, chromium, and pathogens from the wastewater [10-12]. Using nanofiltration technology requires controlling the amount of deposits on the membrane of filtration. One simple solution to solve the problem of befouling is cleaning or replacement of membrane that is expensive and costly. The convenient method is to use some compounds such as fullerenes that can prevent biological fouling. Bacteria and other microorganisms can also attach to each other and accumulate on the filtering membrane and inside the pipes. Gradually, bacteria and other microorganisms absorb other organic materials and create an organic film that can block the membranes. Fullerenes can also be useful by preventing the breathing of bacteria as membrane antifouling agents. Fullerenes, as clot-busting drugs, can prevent clogging of pipes and filtrating membrane. Coating pipes and membranes with these nanoparticles can be used as a suitable strategy to prevent biological fouling of them [13-15].

# 2.2. Nanophotocatalyst and nanoporous catalysts.

The photocatalyst is a material that causes a chemical reaction in sunlight without being changed. These materials are not involved directly in oxidation and reduction reactions and merely provides the conditions required for the reaction. Titanium dioxide has almost all the characteristics of an ideal photocatalyst. Titanium dioxide produces free radicals in the presence of the three elements of water, oxygen, UV radiation that these radicals can breakdown various harmful compounds into lower toxic carbon compounds [16, 17]. Having higher surface to volume ratio, titanium dioxide nanoparticles show more desirable photocatalytic properties compared to larger particles. This material is used as a cover for fixed membranes, nanocrystalline microspheres, and membranes combined with silica to treat leachate resulting from waste material landfills. Titanium dioxide is very hydrophilic and can decompose most of the organic contaminants. Therefore, it is able to absorb heavy metals from wastewater [17, 18].

Porous nanocatalysts can be used to convert the wastes into ethanol. For this purpose, the gasification process is used, in which carbon compounds are converted into syngas under high pressure and temperature in a controlled environment. Syngas is converted to ethanol at the presence of porous nanocatalysts. Syngas is mainly composed of carbon monoxide, hydrogen, lower amounts of carbon dioxide, and methane. Carbon monoxide molecules of syngas are producers of ethanol. Improving the absorption of these molecules by nanocatalysts, suitable conditions are provided to ethanol formation [19, 20].

# 3. Nanotechnology and Air Pollution

Owing to the industrialization of human societies, the production of harmful air pollutants such as NOx, SOx, CO, etc., are increasing. The existing procedures for controlling these contaminants have some limitations so that some of them are not cost-effective, and some others produce hazardous side materials. The majority of these methods are not able to remove very tiny contaminants from the environment. Therefore, it is essential to provide a new lowcost solution to solve this problem [21, 22]. Nanotechnology is one of the current methods used in the world in this regard. Production of nanosensors, nanocatalysts, nanocomposites, nanofilters, and nanobiomaterials are examples of using nanotechnology in environmental issues to reduce air pollutants [23, 24].

# 3.1. Nanostructured membranes.

Among the devices controlling air pollution, filters have the highest application. A filter has a porous structure where gas is passing, and particles remain in the filter. The membrane removes particles through three mechanisms, including direct contact of a particle with filter structure, applying the inertia force when changing the direction of gas, and electric charge effect of particle and structure of the filter. The main shortcoming of filters is the creation of a pressure drop that requires much energy to overcome this problem. Nanofilters have higher efficiency than conventional filters; with pores between 1 and $1 0 \mathrm { n m }$ , they can remove different kinds of bacteria, viruses, and organic contaminants effectively [25, 26].

Membranes based on carbon nanotubes have a higher capacity to separate carbon dioxide from the other gases. Carbon nanotubes can trap gases with a rate of more than 100 times than other gas separation technologies. Therefore, they are suitable for large scale separation. In the case of conventional membranes, there is an inverse relationship between the quality of gas separation and the amount of gas passing, while membranes based on carbon nanotubes have no these shortcomings. Nanomembrane technology can be widely used in the separation and purification of gases and pollutant vapors in various industries and preventing their release in the environment [27, 28].

# 3.2. Catalysts.

Nanostructured materials can also be used as environmental catalysts in the purification of automobile exhaust gases and air filtration. Conventional catalysts that are ceramic or metalbased catalysts have good efficiency, but they are very expensive. Therefore, nanostructured catalysts have been considered as a cheaper alternative for available catalysts [29, 30]. According to conducted research, carbon nanotubes are the most appropriate device to adsorb toxic pollutants such as dioxin and other pollutants releasing from chimneys of incinerator furnaces. Dioxin is a toxic byproduct of many industrial processes leading to long term contamination of air, soil, water, and living organisms, in addition to higher stability. Some dioxins are carcinogenic, and most of them cause disorder in the human immune system. Although many countries have controlled the production of this material in recent years, its environmental dangers are considered as threatening still. While carbon nanotubes are the most appropriate way to adsorb toxic pollutants such as dioxins, the cost high. Various studies are being done on the production of cheap carbon nanotubes. In addition, the use of carbon nanotubes in computer displays reduces the consumption of heavy metals in them, leading to reduced damage to the environment [31-33].

# 3.3. Nanosensors.

One of the most important requirements with regard to air pollution is its continuous controlling. Nanosensors are one of the new technologies in this area that are able to identify and respond to physical stimuli at a nanometre scale. Nanosensors can be classified into two categories of nanoparticles and nanostructured materials. Nanoparticles such as nanoscale spherical materials are used as receptors and as visual-spatial sensors. Nanosensors have been constructed from nanomaterials such as porous silicon, which are used to detect chemical and biological reactions [34, 35].

Leakage of noxious and toxic gas is one of the risks of the industrial sector. Sensors used mainly in the industry often detect low concentrations of these gases lately. This makes it necessary to use new technologies in the production of faster and more accurate sensors. This type of sensor is made of a single layer or multilayer nanotubes, and they can adsorb molecules of toxic gases [34, 36]. They are also able to detect very little amounts of molecules of fatal gases. So far, nanosensors have been designed to identify different types of gaseous compounds, including dioxin, carbon dioxide, sulfur dioxide, nitrogen oxides, ammonia, and so on, having higher accuracy and speed than conventional sensors [37]. A new method of using nanosensors is applying them in the form of smart dust. By producing the first samples of smart dust, the use of such sensors closed to the scientific and applied stage. The main purpose of producing smart dust in the production of a series of advanced sensors in the form of very light nanocomputers. These ultrafine particles are made of silicon and can send the collected data to a central database via wireless in its structure. The data transfer rate is about one Kbps and more in this kind of sensor. These nanosensors remain suspended in the air easily for hours, and they can provide their energy from the sun. Smart dust can transmit data such as temperature, pressure, humidity, the amount of chemicals in the air up to $2 0 \mathrm { k m }$ , and provide conditions to control air pollution continuously in a particular area [38, 39].

# 3.4. Nanocoatings.

Nanostructured coatings have better properties than conventional coatings, including better adhesion and creation of special surface properties. Nanocoatings are used on different surfaces with several microns thickness giving them increased chemical, mechanical and thermal resistance, and self-cleaning properties. The improved properties reduce the amount of raw materials to replace these structures. Additionally, they lead to reduced energy consumption, and reduction needs to consume detergents. As a result, the use of nanocoatings leads to reduced production of pollutant emissions [40-42].

# 4. Nanotechnology: Water and Wastewater Treatment

While approximately three-quarters of Earth's surface area covered with water, one of the biggest challenges of humans is the supply of safe water. To improve the efficiency of water treatment systems, it is necessary to make use of modern tools that quickly convert contaminated water into drinking water. Nanotechnology has reduced the entering of pollutants resulting from human activities to water and the environment. The most important applications of nanotechnology in the environment include using nanofilters, nanoparticles, nanophotocatalyst, nanoclays, and carbon nanotubes in water treatment and using bionanosensors for quick detection of water pollution [43, 44].

# 4.1. Nanofilters.

Depending on the type and size of separable compounds, microfiltration $( 1 0 0 \mathrm { n m } )$ , ultrafiltration $( 1 0 \mathrm { n m } )$ , nanofiltration (1nm), and reverse osmosis $( < 1 \mathrm { n m } )$ methods can be used. Nanofilters are between ultrafiltration and reverse osmosis methods in terms of diameter. Ultrafiltration method due to the higher amount of contaminants than allowed level and reverse osmosis method due to the creation of the purity more than needed. Its high cost consequently has some shortcomings [45]. Filters used in the process of nanofiltration compared with the other methods can treat contaminated water at an appropriate volume and desired quality by spending less energy and higher water penetration. Nanofilters are able to separate a variety of bacteria, viruses, pesticides, organic pollutants, and heavy metals from the water. In the nanofiltration process, no chemical is used for water softening, so its adverse environmental effects are less than conventional chemical methods. Nanofilters used for water treatment, in addition to the separation of bacterial and viral materials, can completely destroy them behind the filter wall. Such capacity is also used in air nanofilters doing exactly the same task [44, 46]. These filters use high surface energy of nanoparticles such as zinc and silver coated on a filter and in contact with any living structure destroy it. In nanofiltration, separation is done based on the size, and filters that have pores at nano sizes do not pass the smallest viruses. The use of active materials such as silver nanoparticles or titanium dioxide and ultraviolet light sources can increase this effect by destroying viruses, bacteria, and fungi trapped. As the size of the filter pores is smaller, the filter will have a higher capacity for separation. The important point on nanofilters compared to other filters is their selectivity power in removing the ions. By using nanofilters, the minerals necessary for human health remain in the water, and harmful substances are removed [47-49].

# 4.2. Nanoparticles.

Nanoparticles have a very broad surface than larger particles. Additionally, these particles are able to interact with various chemical groups leading to an increase in their affinity with the desired compounds [50, 51]. Given these characteristics, nanoparticles can be used as an appropriate tool to absorb pollutants and to treat contaminated water. One of the nanoparticles considered in the adsorption of pollutants is metal nanoparticles that are selected adsorbents with high capacity to adsorb a variety of metal ions and anions [52]. The most important metal nanoparticles used in water and wastewater treatment include silver, lanthanum, manganese oxide, zinc oxide, gold, and iron nanoparticles. Among metal nanoparticles, zero-valent iron (ZVI) nanoparticles are in priority in the treatment process due to abundance, cheapness, nontoxicity, and quick reaction with pollutants. Iron nanoparticles are considered as a new generation of biological monitoring technologies that can be considered a good solution for many environmental problems. These nanoparticles oxidize and decompose polluting compounds such as trichloroethylene, carbon tetrachloride, dioxins, and PCBs, and convert them into carbon compounds with lower toxicity [53, 54]. Neutral iron nanoparticles (nZVI) are used for non-situ and in-situ groundwater treatment. These nanoparticles can be injected directly for underground sources for in-situ treatment, or they can be used in filters for external applications. The advantage of these bimetallic particles related to their high activity, durability of decomposition, and reduced production of toxic materials. However, there are concerns about the toxicity of catalyst metals and the deactivation of the surface of the catalyst by formed a thick layer [55, 56]. Nanostructured bimetallic compounds such as iron-palladium, iron-silver, and zinc-palladium have large applications in the refining environmental pollutants [57].

# 4.3. Nanophotocatalysts.

Nanophotocatalysts are compounds that are important in water treatment. Many pollutants in industrial wastewater, such as alkanes, alkynes, ethers, aldehydes, alcohols, amine compounds, cyanide compounds, ethers, and amide compounds are converted to water and carbon dioxide by nanophotocatalysts such as TiO2. Titanium dioxide releases free radicals at the presence of water, oxygen, and UV radiation that can degrade contaminants into less toxic compounds. Nanophotocatalyst performance efficiency in water treatment depends on water pH, the oxygen content of water, intensity, and extent of contamination [58-60]. Nanophotocatalysts in the powder can be used in suspensions in the form of nanocrystalline microspheres, membranes mixed with silica, or other forms for water treatment. Separation of suspended nanopowders is difficult after treatment. Ultrafiltration or microfiltration is used to separate these particles. However, significant amounts of these particles are destroyed during this process. Applying photocatalysts in the form of nanocrystalline microspheres is more desired for water treatment since they are easily recyclable in this state.

# 4.5. Carbon nanotubes.

Carbon nanotubes are hollow ring structures composed of carbon atoms that can be arranged in the forms of the single or multi-wall. Carbon nanotubes can be used to trace pollution and collect information on environmental pollutants [28, 33]. The major application of nanotubes in water treatment is the preparation of nanotube and nanosieve membranes. Most membranes are made of polymer materials, causing problems and cannot create an appropriate balance between the membrane input and its selectivity. Nanotube membranes provide appropriate selectivity at high inputs. These membranes can almost eliminate all types of water contaminations. Nanometric porosity of nanotubes has made these filters to have higher selectivity than other water treatment technologies [67]. Nanosieves are composed of coupled carbon nanotubes located on a porous and flexible substrate. To form paper-like filters, nanotubes can be placed under a flat or tubular substrate. Different portable filters based on this technology are constructed for water treatment. Some of these filters are at the size of a pencil known as a water stick, having the treatment capacity of one liter of water in 90 seconds. During their useful lifetime, these filters can treat about 300 liters of water that this amount could be increased with change before filtration [68, 69].

# 4.6. Nanosensors.

Nanosensors are very small tools that can detect and respond to stimulants at the scale of one nanometer. Given the need to measure at the molecular and atomic level, using nanotechnology is essential is this regard. Sensors produced at the nanoscale dimensions have extraordinary sensitivity, and they have selective function [35, 70]. One application of nanosensors is controlling the unpleasant odor of water after treatment. Many compounds have been identified in odors resulting from wastewater treatment, including reduced compounds of sulfur or nitrogen, organic acids, aldehydes, or ketones. The commercial sensors that are called electronic nose have been produced to detect microorganisms and heavy metals in drinking water and to determine the characteristics of the odors resulting from a mix of steam collected in a closed container [71, 72].

# 5. Nanomaterials Safety

Apart from being useful, the application of nanotechnology can also have significant potential risks. Therefore, we should take the safety issues and potential risks of this new technology into consideration. The nanomaterial is currently used in many everyday objects such as covering windows, cosmetics, textiles, foods, dyes, medicines, medical equipment, and many other materials. The most common nanomaterials used in consumed products include carbon nanoparticles, titanium nanotubes, zinc nanoparticles, silica, and gold nanoparticles [73, 74]. In general, nanoparticles are produced by three natural, human, and artificial methods that the production of nanoparticles engineered in the environment is more dangerous than normal particles. As any change in the various properties of nanoparticles, such as regional surface affects their solubility and chemical toxicity, engineered nanoparticles are new materials that human beings and other living things may have no sufficient defense mechanisms against them [75]. Lack of public knowledge of environmental toxicity and exposure to them, lack of knowledge on entering of nanomaterials into the environment and transfer of them to humans, lack of familiarity with the risks related to nanomaterials, and the way to prevent them can cause losses to the environment and human societies. Nanoparticles are quickly absorbed through the skin, mucous, and respiratory tract, causing new and unknown toxins that can threaten human health. Therefore, in using nanomaterials, in addition to their benefits, potential hazards associated with them should be considered [75, 76].

# 6. Conclusions

At the nanoscale, material properties are subject to many changes. This has advantages that can lead to good results, including the development of compatibility with the environment. Considering the advantages and various applications of nanotechnology, it can be used in global plans in various environmental areas such as controlling and reducing air pollution, combating with water shortage problems, management of wastes, and other cases as modern science. On the other hand, change in the properties at nanoscale faces the prediction and identification of safety and environmental risks with challenges. Therefore, in using the nanotechnology, its possible risks should be considered.

# Funding

This research received no external funding.

# Acknowledgments

This research has no acknowledgment.

# Conflicts of Interest

The authors declare no conflict of interest.

# References

1. Bayda, S.; Adeel, M.; Tuccinardi, T.; Cordani, M.; Rizzolio, F. The History of Nanoscience and Nanotechnology: From Chemical–Physical Applications to Nanomedicine. Molecules 2020, 25, https://doi.org/10.3390/molecules25010112.   
2. Safaei, M.; Taran, M.; Imani, M.M. Preparation, structural characterization, thermal properties and antifungal activity of alginate-CuO bionanocomposite. Mater. Sci. Eng. C. 2019, 101, 323-329, https://doi.org/10.1016/j.msec.2019.03.108.   
3. Imani, M.M.; Safaei, M. Optimized Synthesis of Magnesium Oxide Nanoparticles as Bactericidal Agents. J. Nanotechnol. 2019, 2019, https://doi.org/10.1155/2019/6063832.   
4. Rezaei, F.; Safarzadeh, M.; Mozafari, H.; Tavakoli, P. Prevalence of geographic tongue and related predisposing factors in 7-18 year-old students in Kermanshah, Iran 2014. Glob. J. Health Sci. 2015, 7, 91-   
95, https://doi.org/10.5539/gjhs.v7n5p91. In: Advances in Nanosensors for Biological and Environmental Analysis. Elsevier. 2019; pp. 119-132, https://doi.org/10.1016/B978-0-12-817456-2.00007-3.   
6. Ahmadi, M.H.; Ghazvini, M.; Alhuyi Nazari, M.; Ahmadi, M.A.; Pourfayaz, F.; Lorenzini, G.; Ming, T. Renewable energy harvesting with the application of nanotechnology: A review. Int. J. Renew. Energy Res. 2019, 43,1387-1410, https://doi.org/10.1002/er.4282.   
7. Babatunde, D.E.; Denwigwe, I.H.; Babatunde, O.M.; Gbadamosi, S.L.; Babalola, I.P.; Agboola, O. Environmental and societal impact of nanotechnology. IEEE Access. 2020, 8, 4640-4667, https://doi.org/10.1109/ACCESS.2019.2961513.   
8. Shekdar, A.V. Sustainable solid waste management: an integrated approach for Asian countries. Waste Manag. 2009, 29, 1438-1448, https://doi.org/10.1016/j.wasman.2008.08.025.   
9. Robinson, T. Membrane bioreactors: Nanotechnology improves landfill leachate quality. Filtr. Sep. 2007, 44, 38-49, https://doi.org/10.1016/S0015-1882(07)70288-4.   
10. Ngo, H.H.; Guo, W.; Xing, W. Applied technologies in municipal solid waste landfill leachate treatment. Waste Water Treatment Technologies 2009, 2.   
11. Li, J.; Zhao, L.; Qin, L.; Tian, X.; Wang, A.; Zhou, Y.; Meng, L.; Chen, Y. Removal of refractory organics in nanofiltration concentrates of municipal solid waste leachate treatment plants by combined Fenton oxidative-coagulation with photo–Fenton processes. Chemosphere 2016, 146, 442-449, https://doi.org/10.1016/j.chemosphere.2015.12.069.   
12. Anand, A.; Singh, S.S. Membrane technique for leachate treatment. Int. J. Environ. Res. Develop. 2014, 4, 33-36.   
13. Chae, S.R.; Wang. S.; Hendren, Z.D.; Wiesner, M.R.; Watanabe, Y.; Gunsch, C.K. Effects of fullerene nanoparticles on Escherichia coli K12 respiratory activity in aqueous suspension and potential use for membrane biofouling control. J. Membr. Sci., 2009, 329, 68-74, https://doi.org/10.1016/j.memsci.2008.12.023.   
14. Liu, S.; Zeng, T.H.; Hofmann, M.; Burcombe, E.; Wei, J.; Jiang, R.; Kong, J.; Chen, Y. Antibacterial activity of graphite, graphite oxide, graphene oxide, and reduced graphene oxide: membrane and oxidative stress. ACS nano., 2011, 5, 6971-6980. https://doi.org/10.1021/nn202451x   
15. Mansouri, J.; Harrisson, S.; Chen, V. Strategies for controlling biofouling in membrane filtration systems: challenges and opportunities. J. Mater. Chem. 2010, 20, 4567-4586, https://doi.org/10.1039/b926440j.   
16. Liao, CH.; Huang, C.W.; Wu, J. Hydrogen production from semiconductor-based photocatalysis via water splitting. Catalysts 2012, 2, 490-516, https://doi.org/10.3390/catal2040490.   
17. Schneider, J.; Matsuoka, M.; Takeuchi, M.; Zhang, J.; Horiuchi, Y.; Anpo, M.; Bahnemann, D.W. Understanding TiO2 photocatalysis: mechanisms and materials. Chem. Rev. 2014, 114, 9919-9986, https://doi.org/10.1021/cr5001892.   
18. Kyung, H.; Lee, J.; Choi, W. Simultaneous and synergistic conversion of dyes and heavy metal ions in aqueous TiO2 suspensions under visible-light illumination. Environ. Sci. Technol. 2005, 39, 2376-2382, https://doi.org/10.1021/es0492788.   
19. Akia, M.; Yazdani, F.; Motaee, E.; Han, D.; Arandiyan, H. A review on conversion of biomass to biofuel by nanocatalysts. Biofuel Res. J. 2014, 1, 16-25, https://doi.org/10.18331/BRJ2015.1.1.5.   
20. Abdollahi, M.; Yu, J.; Liu, P.K.; Ciora, R.; Sahimi, M.; Tsotsis, T.T. Hydrogen production from coal-derived syngas using a catalytic membrane reactor based process. J. Membr. Sci. 2010, 363, 160-169, https://doi.org/10.1016/j.memsci.2010.07.023.   
21. Chen, B.; Kan, H. Air pollution and population health: a global challenge. Environ. Health. Prev. Med. 2008, 13, 94-101, https://doi.org/10.1007/s12199-007-0018-5.   
22. Griffin, R.D. Principles of hazardous materials management. 2st edition. CRC Press, 2009.   
23. Baraton, M.I.; Merhari, L. Advances in air quality monitoring via nanotechnology. J. Nanopart. Res. 2004, 6, 107-117, https://doi.org/10.1023/B:NANO.0000023239.56676.12.   
24. Fulekar, M.H.; Pathak, B.; Kale, R.K. Chapter 7-Nanotechnology: perspective for environmental sustainability. In: Environment and Sustainable Development. Springer India, 2014; pp. 87-114, https://doi.org/10.1007/978-3-319-58538-3_96-1.   
25. Sutherland, K.S.; Chase, G. Filters and filtration handbook. 5th Edition. Elsevier, 2011.   
26. Schafer, A.I.; Fane, A.G.; Waite, T.D. Nanofiltration: principles and applications. Elsevier; 2005.   
27. Skoulidas, A.I.; Sholl, D.S.; Johnson, J.K. Adsorption and diffusion of carbon dioxide and nitrogen through single-walled carbon nanotube membranes. J. Chem. Phys. 2006, 124, https://doi.org/10.1063/1.2151173.   
28. Zhang, L.; Zhao, B.; Jiang, C.; Yang, J.; Zheng, G. Preparation and transport performances of high-density, aligned carbon nanotube membranes. Nanoscale Res. Lett. 2015, 10, https://doi.org/10.1186/s11671-015- 0970-8.   
29. Koga, H.; Umemura, Y.; Tomoda, A.; Suzuki, R.; Kitaoka, T. In situ synthesis of platinum nanocatalysts on a microstructured paperlike matrix for the catalytic purification of exhaust gases. ChemSusChem. 2010, 3, 604-618, https://doi.org/10.1002/cssc.200900277.   
30. Chaturvedi, S.; Dave, P.N.; Shah, N.K. Applications of nanocatalyst in new era. J. Saudi Chem. Soc. 2012, 16, 307-325, https://doi.org/10.1016/j.jscs.2011.01.015.   
31. Zhou, X.; Li, X.; Xu, S.; Zhao, X.; Ni, M.; Cen, K. Comparison of adsorption behavior of PCDD/Fs on carbon nanotubes and activated carbons in a bench-scale dioxin generating system. Environ. Sci. Pollut. Res. 2015, 22, 10463-10470, https://doi.org/10.1007/s11356-015-4180-9.   
32. Long, R.Q.; Yang, R.T. Carbon nanotubes as superior sorbent for dioxin removal. J. Am. Chem. Soc. 2001, 123, 2058-2059, https://doi.org/10.1021/ja003830l.   
33. Rafique, M.M.; Iqbal, J. Production of carbon nanotubes by different routes-a review. J. Encapsul. Adsorpt. Sci. 2011, 1, 29-34, https://doi.org/10.4236/jeas.2011.12004.   
34. Jimenez-Cadena, G.; Riu, J.; Rius, F.X. Gas sensors based on nanostructured materials. Analyst 2007, 132, 1083-1099, https://doi.org/10.1039/B704562J.   
35. Peng, F.; Su, Y.; Zhong, Y.; Fan, C.; Lee, S.T.; He, Y. Silicon nanomaterials platform for bioimaging, biosensing, and cancer therapy. Acc. Chem. Res. 2014, 47, 612-623, https://doi.org/10.1021/ar400221g.   
36. Yuan, W.; Shi, G. Graphene-based gas sensors. J. Mater. Chem. A. 2013, 1, 10078-10091, https://doi.org/10.1039/C3TA11774J.   
37. Eranna, G. Metal oxide nanostructures as gas sensing devices. CRC Press, 2011.   
38. Fischer, T.; Agarwal, A.; Hess, H. A smart dust biosensor powered by kinesin motors. Nat. Nanotechnol. 2009, 4, 162-166, https://doi.org/10.1038/nnano.2008.393.   
39. Dickson, S.A. Enabling battlespace persistent surveillance: The form, function, and future of smart dust. Air war coll maxwell afb al center for strategy and technology. 2007; pp. 1-43.   
40. Yaghoubi, H.; Taghavinia, N.; Alamdari, E.K. Self cleaning $\mathrm { T i O } _ { 2 }$ coating on polycarbonate: surface treatment, photocatalytic and nanomechanical properties. Surf. Coating Tech. 2010, 204, 1562-1568, https://doi.org/10.1016/j.surfcoat.2009.09.085.   
41. Deepak, S.S.; Thakur, M. Methods of Pollution Control using Nano-Particles. Int. J. Adv. Engg. Res. Studies. 2015, 4, 215-217.   
42. Nasrollahi, F.; Moradi, E.; Rafiei, M. Nano coating and reducing the energy consumption in city buildings. Majlesi J. Energ. Manag., 2014, 3, 17-22.   
43. Spellman, F.R. The science of water: Concepts and applications. CRC press, 2014.   
44. Qu, X.; Alvarez, P.J.; Li, Q. Applications of nanotechnology in water and wastewater treatment. Water. Res. 2013, 47, 3931-3946, https://doi.org/10.1016/j.watres.2012.09.058.   
45. Charcosset, C. Ultrafiltration, microfiltration, nanofiltration and reverse osmosis in integrated membrane processes. In: Integrated membrane systems and processes. Wiley and Sons Inc, 2016; https://doi.org/10.1002/9781118739167.ch1.   
46. Shannon, M.A.; Bohn, P.W.; Elimelech, M.; Georgiadis, J.G.; Marinas, B.J.; Mayes, A.M. Science and technology for water purification in the coming decades. Nature 2008, 452, 301-310, https://doi.org/10.1038/nature06599.   
47. Ronen, A.; Semiat, R.; Dosoretz, C.G. Antibacterial efficiency of composite nano-ZnO in biofilm development in flow-through systems. Desalination. Water Treat. 2013, 51, 988-996, https://doi.org/10.1080/19443994.2012.693698.   
48. Huang, Z.H.; Yin, Y.N.; Zhang, Y. Preparation of a novel positively charged nanofiltration composite membrane incorporated with silver nanoparticles for pharmaceuticals and personal care product rejection and antibacterial properties. Water Sci. Technol. 2016, 73, 1910-1919, https://doi.org/10.2166/wst.2016.037.   
49. Brenner, A.; Persson, K.M.; Russell, L.; Rosborg, I.; Kozisek, F. Technical and mineral level effects of water treatment. In drinking water minerals and mineral balance. Springer international publishing, 2015; pp. 103- 117.   
50. Safaei, M.; Taran, M.; Imani, M.M.; Moradpoor, H.; Rezaei, F.; Jamshidy, L.; Rezaei, R. Application of Taguchi method in the optimization of synthesis of cellulose-MgO bionanocomposite as antibacterial agent. Polish J. Chem. Technol. 2019, 21, 116-22, https://doi.org/10.2478/pjct-2019-0047.   
51. Safaei, M.; Taran, M.; Jamshidy, L.; Imani, M.M.; Mozaffari, H.R.; Sharifi, R.; Golshah, A.; Moradpoor, H. Optimum synthesis of polyhydroxybutyrate-Co3O4 bionanocomposite with the highest antibacterial activity against multidrug resistant bacteria. Int. J. Biol. Macromol. 2020, 158, 477-485, https://doi.org/10.1016/j.ijbiomac.2020.04.017.   
52. Narasaiah, B.P.; Mandal, B.K. Bio-fabricated CuO NPs as green catalyst towards remediation of environmental pollutants. Lett. Appl. NanoBioScience 2019, 8, 597-603, https://doi.org/10.33263/LIANBS83.597603.   
53. Agarwal, M.; Patel, D. Modified zero valent Iron (ZVI) nanoparticles for removal of manganese from water. Int. J. Environ. Res. 2015, 9, 1055-1068, https://doi.org/10.22059/IJER.2015.993.   
54. Guo, X.; Yang, Z.; Dong, H.; Guan, X.; Ren, Q.; Lv, X.; Jin, X. Simple combination of oxidants with zerovalent-iron (ZVI) achieved very rapid and highly efficient removal of heavy metals from water. Water. Res. 2016, 88, 671-680, https://doi.org/10.1016/j.watres.2015.10.045.   
55. Kober, R.; Hollert, H.; Hornbruch, G.; Jekel, M.; Kamptner, A.; Klaas, N.; Maes, H.; Mangold, K.M.; Martac, E.; Matheis, A.; Paar, H. Nanoscale zero-valent iron flakes for groundwater treatment. Environ. Earth Sci. 2014, 72, 1-14, http://dx.doi.org/10.1007/s12665-016-5485-9.   
56. Fu, F.; Dionysiou, D.D.; Liu, H. The use of zero-valent iron for groundwater remediation and wastewater treatment: a review. J. Hazard. Mater. 2014, 267, 194-205, https://doi.org/10.1016/j.jhazmat.2013.12.062. Environ. Sci. Technol. 2001, 35, 4922-4926, https://doi.org/10.1021/es0108584.   
58. Mahmoodi, N.M.; Arami, M. Degradation and toxicity reduction of textile wastewater using immobilized titania nanophotocatalysis. J. Photochem. Photobiol. B., 2009, 94, 20-24, https://doi.org/10.1016/j.jphotobiol.2008.09.004.   
59. Mahmoodi, N.M.; Arami, M.; Limaee, N.Y.; Gharanjig, K.; Nourmohammadian, F. Nanophotocatalysis using immobilized titanium dioxide nanoparticle: degradation and mineralization of water containing organic pollutant: case study of Butachlor. Mater. Res. BulL. 2007, 42, 797-806, https://doi.org/10.1016/j.materresbull.2006.08.031.   
60. Al Sadi, S.; Feroz, S.; Rao, L.N.; Suneel, D. Treatment of industrial wastewater by solar nano photocatalysis. In: Proceedings of international conference on recent trends in mechanical engineering-2K15. p. 21st, 2015.   
61. Mazinani, B.; Masrom, A.K.; Beitollahi, A.; Luque, R. Photocatalytic activity, surface area and phase modification of mesoporous SiO2–TiO2 prepared by a one-step hydrothermal procedure. Ceram Int. 2014,   
40, 11525-11532, https://doi.org/10.1016/j.ceramint.2014.03.071.   
62. Antwi, D.M.B.; Acheampong, M.A. Modification of titanium dioxide nanoparticles for phosphate removal from waste water. J. Appl. Sci. Tech. Manag. 2016, 1, 18-36, https://doi.org/10.17265/2162-   
5298/2016.10.002.   
63. Patel, H.A.; Somani, R.S.; Bajaj, H.C.; Jasra, R.V. Nanoclays for polymer nanocomposites, paints, inks, greases and cosmetics formulations, drug delivery vehicle and waste water treatment. Bull. Mater. Sci. 2006,   
29, 133-145, https://doi.org/10.1007/BF02704606.   
64. Safaei, M.; Boldaji, F.; Dastar, B.; Hassani, S. The effect of dietary silicate minerals supplementation on apparent ileal digestibility of energy and protein in broiler chickens. Int. J. Agric. Biol. 2012, 14, 299-302.   
65. Safaei, M.; Jafariahangari, Y.; Baharlouei, A.K. Effects of dietary inclusion of sodium bentonite on biochemical characteristics of blood serum in broiler chickens. Int. J. Agric. Biol. 2010, 12, 877-80.   
66. Wang, S.; Peng, Y. Natural zeolites as effective adsorbents in water and wastewater treatment. Chem. Eng. J., 2010, 156, 11-24, https://doi.org/10.1016/j.cej.2009.10.029.   
67. Das, R.; Ali, M.E.; Hamid, S.B.A.; Ramakrishna, S.; Chowdhury, Z.Z. Carbon nanotube membranes for water purification: a bright future in water desalination. Desalination 2014, 336, 97-109, https://doi.org/10.1016/j.desal.2013.12.026.   
68. Gutierrez, F.J.; Mussons, M.L.; Gaton, P.; Rojo, R. Nanotechnology and food industry. Intech open access publisher 2012.   
69. Bhati, M. Innovation ecosystem of nano water research in India: step towards basic research to commercialization. In: Pure and applied chemistry international conference 2013; pp. 20-29.   
70. Bellan, L.M.; Wu, D.; Langer, R.S. Current trends in nanobiosensor technology. Wiley Interdiscip. Rev. Nanomed. Nanobiotechnol. 2011, 3, 229-246, https://doi.org/10.1002/wnan.136.   
71. https://doi.org/10.1002/wnan.136   
72. Samendra, P.S.; Masaaki, K.; Charles, P.G.; Ian, L.P. Rapid detection technologies for monitoring microorganisms in water. Biosens. J. 2014, 3, 109-116.   
73. Canhoto, O.; Magan, N. Electronic nose technology for the detection of microbial and chemical contamination of potable water. Sens. Actuators. B Chem. 2005, 106, 3-6, https://doi.org/10.1016/j.snb.2004.05.029.   
74. Mahapatra, I.; Clark, J.R.; Dobson, P.J.; Owen, R.; Lynch, I.; Lead, J.R. Expert perspectives on potential environmental risks from nanomedicines and adequacy of the current guideline on environmental risk assessment. Environ. Sci. Nano., 2018, 5, 1873-1889, https://doi.org/10.1039/C8EN00053K.   
75. Njuguna, J.; Pielichowski, K.; Zhu, H. Health and environmental safety of nanomaterials: Polymer nancomposites and other materials containing nanoparticles. Elsevier, 2014.   
76. Riediker, M.; Zink, D.; Kreyling, W.; Oberdörster, G.; Elder, A.; Graham, U.; Lynch, I.; Duschl, A.; Ichihara, G.; Ichihara, S.; Kobayashi, T. Particle toxicology and health-where are we? Part. Fibre Toxicol. 2019, 16, https://doi.org/10.1186/s12989-019-0302-8.   
77. Kumar, A.; Kumar, P.; Anandan, A.; Fernandes, T.F.; Ayoko, G.A.; Biskos, G. Engineered nanomaterials: knowledge gaps in fate, exposure, toxicity, and future directions. J Nanomater. 2014, 2014, https://doi.org/10.1155/2014/130198.